package com.agilex.healthcare.directscheduling.exception;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class DirectSchedulingExceptionMapper implements ExceptionMapper<DirectSchedulingException> {

	@Override
	public Response toResponse(DirectSchedulingException ex) {
		return Response.status(Status.INTERNAL_SERVER_ERROR).entity(ex.getMessage()).type(MediaType.APPLICATION_JSON).build();
	}
}